//
//  MCPRelationship.h
//  MCPersistence
//
//  Created by aj on Fri Dec 21 2001.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MCPDefinitionObject.h"
#import "MCPDefines.h"

@class MCPEntity;
@class BDQualifier;
@class MCPJoin;

@interface MCPRelationship : MCPDefinitionObject {

	NSMutableArray		*_joins;
	MCPEntity			*_entity;
	
	BOOL				_inverseDetermined;
	MCPRelationship		*_inverseRelationship;
	
	BOOL				_intermediateDetermined;
	MCPRelationship		*_intermediateRelationship;
	
	BOOL				_isFlattened;
	BOOL				_ownsDestination;
	BOOL				_propagatesPrimaryKey;

	BOOL				_determinedToMany;
	BOOL				_isToMany;
	
	
	SEL					_createAndAddSelector;
	SEL					_addToSelector;
	SEL					_relationshipSelector;
	SEL					_removeSelector;
	
	BOOL				_builtSelector;
	
	MCPDeleteRule		  _deleteRule;
    MCPSupportedPlatforms _supportedPlatforms;
    NSString*             _supportedProduct;
}

- (void)setEntity:(MCPEntity *)entity;
- (MCPEntity *)entity;

- (SEL)relationshipSelector;
- (SEL)createSelector;
- (SEL)addToSelector;
- (SEL)removeFromSelector;


- (NSString *)name;
- (NSString *)definition;

- (MCPSupportedPlatforms)supportedPlatforms;
- (void)setSupportedPlatforms:(MCPSupportedPlatforms)aVal;

- (NSString*)supportedProduct;
- (void)setSupportedProduct: (NSString*)aProduct;

- (NSString *)destinationName;
- (MCPEntity *)destinationEntity;
- (void)setDestinationEntity:(MCPEntity *)aDestEnt;

- (NSArray *)joins;
- (MCPJoin *)createAndAddJoin;

// If the destination has a relationship pointing back, that is returned, otherwise nil
- (NSArray *)inverseRelationships;
- (MCPRelationship *)inverseRelationship;
- (MCPRelationship *)intermediateRelationship;

// if we are a normal relationship, then we try to get the flattened counterpart
- (MCPRelationship *)flattenedRelationship;


- (BOOL)isFlattened;
- (BOOL)isToMany;
- (void)setIsToMany:(BOOL)aFlag;

- (BOOL)ownsDestination;
- (void)setOwnsDestination: (BOOL)flag;

- (BOOL)propagatesPrimaryKey;

- (MCPDeleteRule)deleteRule;
- (void)setDeleteRule: (MCPDeleteRule)rule;

- (BDQualifier *)inMemoryObjectQualifierUsingSourceObject:(id)obj;
- (NSString *)inMemoryObjectKeyStringUsingSourceObject:(id)obj;

- (NSString *)linkedFlagAttributeName;
- (MCPJoin*) join;

- (void) setName:(NSString *)name;
- (void) setDefinition:(NSString *)def;
- (void) setDestinationName:(NSString *)destination;

@end
